/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.dialog.IVWWebServiceParamPanel;
import filenet.vw.toolkit.design.property.dialog.VWInvokeWSOperationParameterPanel;
import filenet.vw.toolkit.design.property.dialog.VWOperationListCellRenderer;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import filenet.vw.toolkit.utils.table.VWSortedComboBoxModel;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.expressionbuilder.VWExpressionBuilderDialog;
import filenet.ws.api.WSOperation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWInvokeGeneralPanel
extends JPanel
implements ActionListener,
DocumentListener,
IVWPropertyChangeListener,
IVWToolbarBorderActionListener {
    private static final int MODE_BASIC = 0;
    private static final int MODE_ADVANCED = 1;
    private JComboBox m_partnerLinkCombo = null;
    private JComboBox m_operationCombo = null;
    private JRadioButton m_basicRB = null;
    private JRadioButton m_advancedRB = null;
    private VWInvokeWSOperationParameterPanel m_incomingParamPanel = null;
    private VWInvokeWSOperationParameterPanel m_outgoingParamPanel = null;
    private VWToolbarBorder m_outgoingMsgBorder = null;
    private JTextArea m_outgoingMsgTextArea = null;
    private VWToolbarBorder m_incomingXMLDataFieldBorder = null;
    private JComboBox m_incomingXMLDataFieldComboBox = null;
    private IVWWebServiceParamPanel m_parentWSParamPanel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInvokeInstruction m_instructionDef = null;

    public VWInvokeGeneralPanel(JDialog parent, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentWSParamPanel = parentPanel;
        this.createControls(nDisplayMode);
    }

    public VWInvokeGeneralPanel(Frame parent, IVWWebServiceParamPanel parentPanel, VWAuthPropertyData authPropertyData, int nDisplayMode) {
        this.m_authPropertyData = authPropertyData;
        this.m_parentWSParamPanel = parentPanel;
        this.createControls(nDisplayMode);
    }

    public void setInstructionDefinition(VWInvokeInstruction instructionDef) {
        this.m_instructionDef = instructionDef;
        this.reinitialize();
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src.equals(this.m_partnerLinkCombo)) {
            this.performPartnerLinkAction();
        } else if (src.equals(this.m_operationCombo)) {
            this.performOperationAction();
        } else if (src.equals(this.m_basicRB)) {
            this.performBasicAction();
        } else if (src.equals(this.m_advancedRB)) {
            this.performAdvancedAction();
        } else if (src.equals(this.m_incomingXMLDataFieldComboBox)) {
            this.performIncomingXMLDataFieldAction();
        }
    }

    public void changedUpdate(DocumentEvent event) {
        if (event.getDocument().equals(this.m_outgoingMsgTextArea.getDocument())) {
            this.updateOutgoingMsg();
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(event);
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 526: 
            case 527: 
            case 528: 
            case 529: {
                this.reinitialize();
                break;
            }
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 563: 
            case 564: 
            case 565: {
                this.initIncomingXMLDataFieldComboBox();
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            Object src = event.getSource();
            if (src.equals(this.m_outgoingMsgBorder)) {
                VWExpressionBuilderDialog expressionBuilderDlg = new VWExpressionBuilderDialog(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData, null, this.m_outgoingMsgTextArea.getText(), 2703);
                expressionBuilderDlg.init();
                expressionBuilderDlg.setVisible(true);
                if (expressionBuilderDlg.getDialogResult() == 0) {
                    this.setOutgoingMsgText(expressionBuilderDlg.getExpressionString());
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createControls(int nDisplayMode) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 0, 5);
            if (nDisplayMode == 0) {
                gbCons.weightx = 0.5;
                gbCons.insets = new Insets(5, 0, 0, 20);
            }
            VWToolbarBorder partnerLinkBorder = new VWToolbarBorder(VWResource.s_partnerLink);
            JPanel partnerLinkPanel = partnerLinkBorder.getClientPanel();
            partnerLinkPanel.setLayout(new BorderLayout());
            this.m_partnerLinkCombo = new JComboBox();
            this.m_partnerLinkCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_partnerLinkCombo.addActionListener(this);
            partnerLinkPanel.add(this.m_partnerLinkCombo);
            this.add((Component)partnerLinkBorder, gbCons);
            ++gbCons.gridy;
            VWToolbarBorder operationBorder = new VWToolbarBorder(VWResource.s_operation, 0x40000000);
            JPanel operationPanel = operationBorder.getClientPanel();
            operationPanel.setLayout(new BorderLayout());
            this.m_operationCombo = new JComboBox();
            this.m_operationCombo.setRenderer(new VWOperationListCellRenderer(this.m_authPropertyData.getWebServiceUtils()));
            this.m_operationCombo.addActionListener(this);
            operationPanel.add(this.m_operationCombo);
            this.add((Component)operationBorder, gbCons);
            ++gbCons.gridy;
            if (nDisplayMode == 0) {
                ++gbCons.gridx;
                gbCons.gridy = 0;
                gbCons.gridwidth = 0;
                gbCons.insets = new Insets(5, 0, 0, 5);
            }
            this.add((Component)this.getModePanel(), gbCons);
            gbCons.fill = 1;
            ++gbCons.gridy;
            gbCons.weighty = 0.5;
            gbCons.gridwidth = 1;
            this.m_outgoingParamPanel = new VWInvokeWSOperationParameterPanel(this.m_authPropertyData, 1);
            this.add((Component)this.m_outgoingParamPanel, gbCons);
            gbCons.weighty = 1.0;
            this.m_outgoingMsgBorder = new VWToolbarBorder(VWResource.s_outgoingMessage, 32);
            this.m_outgoingMsgBorder.addToolbarBorderActionNotifier(this);
            JPanel outgoingMsgPanel = this.m_outgoingMsgBorder.getClientPanel();
            outgoingMsgPanel.setLayout(new BorderLayout());
            this.m_outgoingMsgTextArea = new JTextArea();
            this.m_outgoingMsgTextArea.setTabSize(4);
            this.m_outgoingMsgTextArea.getDocument().addDocumentListener(this);
            outgoingMsgPanel.add(new JScrollPane(this.m_outgoingMsgTextArea));
            this.add((Component)this.m_outgoingMsgBorder, gbCons);
            ++gbCons.gridy;
            if (nDisplayMode == 0) {
                ++gbCons.gridx;
                --gbCons.gridy;
                gbCons.gridwidth = 0;
                gbCons.insets = new Insets(5, 0, 0, 5);
            }
            this.m_incomingParamPanel = new VWInvokeWSOperationParameterPanel(this.m_authPropertyData, 0);
            this.add((Component)this.m_incomingParamPanel, gbCons);
            gbCons.fill = 2;
            gbCons.weighty = 0.0;
            this.m_incomingXMLDataFieldBorder = new VWToolbarBorder(VWResource.s_incomingXMLDataField, 0x40000000);
            JPanel incomingXMLPanel = this.m_incomingXMLDataFieldBorder.getClientPanel();
            incomingXMLPanel.setLayout(new BorderLayout());
            this.m_incomingXMLDataFieldComboBox = new JComboBox(new VWSortedComboBoxModel());
            this.m_incomingXMLDataFieldComboBox.setRenderer(new VWLabelListCellRenderer());
            this.m_incomingXMLDataFieldComboBox.setEditable(true);
            this.m_incomingXMLDataFieldComboBox.addActionListener(this);
            this.initIncomingXMLDataFieldComboBox();
            incomingXMLPanel.add(this.m_incomingXMLDataFieldComboBox);
            this.add((Component)this.m_incomingXMLDataFieldBorder, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
    }

    private JPanel getModePanel() {
        VWToolbarBorder messageTypeBorder = new VWToolbarBorder(VWResource.s_messageType);
        JPanel msgTypePanel = messageTypeBorder.getClientPanel();
        msgTypePanel.setLayout(new FlowLayout(3));
        this.m_basicRB = new JRadioButton(VWResource.s_parametersStr);
        this.m_basicRB.setSelected(true);
        this.m_basicRB.addActionListener(this);
        msgTypePanel.add(this.m_basicRB);
        msgTypePanel.add(Box.createHorizontalStrut(20));
        this.m_advancedRB = new JRadioButton(VWResource.s_xml);
        this.m_advancedRB.setSelected(false);
        this.m_advancedRB.addActionListener(this);
        msgTypePanel.add(this.m_advancedRB);
        ButtonGroup msgTypeGrp = new ButtonGroup();
        msgTypeGrp.add(this.m_basicRB);
        msgTypeGrp.add(this.m_advancedRB);
        return messageTypeBorder;
    }

    private void reinitialize() {
        if (this.m_instructionDef != null) {
            this.initPartnerLinkComboBox();
            this.initOperationComboBox(false);
            this.m_incomingParamPanel.reinitialize(this.m_instructionDef, null);
            this.m_outgoingParamPanel.reinitialize(this.m_instructionDef, null);
            this.m_outgoingMsgTextArea.getDocument().removeDocumentListener(this);
            this.m_outgoingMsgTextArea.setText(this.m_instructionDef.getInputMsgExpr());
            this.m_outgoingMsgTextArea.getDocument().addDocumentListener(this);
            this.initIncomingXMLDataFieldComboBox();
            try {
                if (this.m_instructionDef.getOutGoingParameterDefinitions() == null && this.m_instructionDef.getInComingParameterDefinitions() == null) {
                    this.setMode(1);
                } else {
                    this.setMode(0);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                this.setMode(1);
            }
        }
    }

    private void initPartnerLinkComboBox() {
        Object[] partnerLinkNames = null;
        boolean bFound = false;
        if (this.m_instructionDef != null) {
            String partnerLinkName = this.m_instructionDef.getPartnerLinkName();
            this.m_partnerLinkCombo.removeActionListener(this);
            this.m_partnerLinkCombo.removeAllItems();
            this.m_partnerLinkCombo.addItem(VWResource.s_noneItemStr);
            if (this.m_authPropertyData != null) {
                VWPartnerLinkDefinition[] partnerLinks = null;
                try {
                    int count;
                    partnerLinks = this.m_authPropertyData.getPartnerLinks();
                    if (partnerLinks != null && (count = partnerLinks.length) > 0) {
                        Vector<String> nameVector = new Vector<String>();
                        for (int i = 0; i < count; ++i) {
                            VWPartnerLinkDefinition partnerLink = partnerLinks[i];
                            String endPoint = partnerLink.getPartnerEndPoint();
                            if (endPoint == null) continue;
                            nameVector.addElement(partnerLink.getName());
                        }
                        int nameCount = nameVector.size();
                        if (nameCount > 0) {
                            partnerLinkNames = new String[nameCount];
                            nameVector.copyInto(partnerLinkNames);
                            nameVector.removeAllElements();
                            nameVector = null;
                        }
                        if (partnerLinkNames != null) {
                            VWQubbleSort.sort(partnerLinkNames);
                            for (int i = 0; i < nameCount; ++i) {
                                this.m_partnerLinkCombo.addItem(partnerLinkNames[i]);
                                if (bFound || partnerLinkName == null) continue;
                                bFound = partnerLinkName.compareTo((String)partnerLinkNames[i]) == 0;
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
                if (partnerLinkNames != null) {
                    if (partnerLinkName != null && partnerLinkName.length() > 0) {
                        if (!bFound) {
                            this.m_partnerLinkCombo.addItem(partnerLinkName);
                        }
                        this.m_partnerLinkCombo.setSelectedItem(partnerLinkName);
                    } else {
                        this.m_partnerLinkCombo.setSelectedIndex(0);
                    }
                } else {
                    this.m_partnerLinkCombo.setSelectedIndex(0);
                }
            }
            this.m_partnerLinkCombo.addActionListener(this);
        }
    }

    private void initOperationComboBox(boolean bDisplayError) {
        String operationName = null;
        int nOperationIndex = -1;
        this.m_operationCombo.removeActionListener(this);
        this.m_operationCombo.removeAllItems();
        this.m_operationCombo.addItem(VWResource.s_noneItemStr);
        if (this.m_instructionDef != null) {
            operationName = this.m_instructionDef.getOperationName();
            try {
                String partnerLinkName;
                if (this.m_instructionDef != null && (partnerLinkName = this.m_instructionDef.getPartnerLinkName()) != null && partnerLinkName.length() > 0 && this.m_authPropertyData != null) {
                    WSOperation[] wsOperations;
                    VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                    VWPartnerLinkDefinition partnerLinkDef = this.m_authPropertyData.getPartnerLink(partnerLinkName);
                    if (partnerLinkDef != null && wsUtils != null && (wsOperations = wsUtils.getOperationsFromPartnerLink(partnerLinkDef, bDisplayError)) != null && wsOperations.length > 0) {
                        for (int i = 0; i < wsOperations.length; ++i) {
                            this.m_operationCombo.addItem(wsOperations[i]);
                            if (nOperationIndex != -1 || operationName == null || operationName.compareTo(wsOperations[i].getDisplayName()) != 0) continue;
                            nOperationIndex = i + 1;
                            this.m_basicRB.setEnabled(wsUtils.isSimpleOperation(wsOperations[i]));
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        if (nOperationIndex != -1) {
            this.m_operationCombo.setSelectedIndex(nOperationIndex);
        } else if (operationName != null && operationName.length() > 0) {
            this.m_operationCombo.addItem(operationName);
            this.m_operationCombo.setSelectedItem(operationName);
        } else {
            this.m_operationCombo.setSelectedIndex(0);
        }
        this.m_operationCombo.addActionListener(this);
    }

    private void initIncomingXMLDataFieldComboBox() {
        boolean found = false;
        String incomingXMLDataField = null;
        if (this.m_instructionDef != null) {
            incomingXMLDataField = this.m_instructionDef.getOutputMsgExpr();
        }
        this.m_incomingXMLDataFieldComboBox.removeActionListener(this);
        try {
            VWSortedComboBoxModel model = (VWSortedComboBoxModel)this.m_incomingXMLDataFieldComboBox.getModel();
            if (model != null) {
                model.removeAllElements();
                model.addElement(VWResource.s_noneItemStr);
                VWFieldDefinition[] fieldDefs = this.m_authPropertyData.getFields();
                if (fieldDefs != null) {
                    for (int i = 0; i < fieldDefs.length; ++i) {
                        VWFieldDefinition fieldDef = fieldDefs[i];
                        int fieldType = fieldDef.getFieldType();
                        String fieldName = fieldDef.getName();
                        if (fieldType == 128 || fieldType == 2) {
                            model.addElement(fieldName);
                        }
                        if (found || incomingXMLDataField == null || VWStringUtils.compare(fieldName, incomingXMLDataField) != 0) continue;
                        found = true;
                    }
                }
                if (!found && incomingXMLDataField != null && incomingXMLDataField.length() > 0) {
                    model.addElement(incomingXMLDataField);
                }
                model.sort(VWResource.s_noneItemStr);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        if (incomingXMLDataField != null && incomingXMLDataField.length() > 0) {
            this.m_incomingXMLDataFieldComboBox.setSelectedItem(incomingXMLDataField);
        } else {
            this.m_incomingXMLDataFieldComboBox.setSelectedItem(VWResource.s_noneItemStr);
        }
        this.m_incomingXMLDataFieldComboBox.addActionListener(this);
    }

    private void performPartnerLinkAction() {
        try {
            String partnerLink = (String)this.m_partnerLinkCombo.getSelectedItem();
            if (partnerLink.compareTo(VWResource.s_noneItemStr) == 0) {
                partnerLink = "";
            }
            if (this.m_instructionDef != null) {
                this.m_instructionDef.setPartnerLinkName(partnerLink);
                this.m_instructionDef.setOperationName(null);
                this.m_instructionDef.setInputMsgName(null);
                this.m_instructionDef.setOutputMsgName(null);
                this.m_authPropertyData.setDirty();
            }
            this.resetMessages();
            this.setMode(0);
            this.initOperationComboBox(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performOperationAction() {
        try {
            this.resetMessages();
            WSOperation wsOperation = this.getSelectedOperation();
            if (wsOperation == null) {
                this.setMode(0);
                if (this.m_instructionDef != null) {
                    this.m_instructionDef.setOperationName(null);
                    this.m_instructionDef.setInputMsgName(null);
                    this.m_instructionDef.setOutputMsgName(null);
                }
            } else {
                VWWebServiceUtils wsUtils;
                if (this.m_instructionDef != null) {
                    this.m_instructionDef.setOperationName(wsOperation.getDisplayName());
                    this.m_instructionDef.setInputMsgName(wsOperation.getInputName());
                    this.m_instructionDef.setOutputMsgName(wsOperation.getOutputName());
                }
                if ((wsUtils = this.m_authPropertyData.getWebServiceUtils()) != null && wsUtils.isSimpleOperation(wsOperation)) {
                    this.performBasicAction();
                    this.m_basicRB.setEnabled(true);
                } else {
                    this.performAdvancedAction();
                    this.m_basicRB.setEnabled(false);
                }
            }
            this.m_authPropertyData.setDirty();
            if (this.m_parentWSParamPanel != null) {
                this.m_parentWSParamPanel.setOperation(wsOperation);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private WSOperation getSelectedOperation() {
        Object selectedOperation = this.m_operationCombo.getSelectedItem();
        if (selectedOperation != null) {
            if (selectedOperation instanceof String) {
                if (((String)selectedOperation).compareTo(VWResource.s_noneItemStr) == 0) {
                    return null;
                }
            } else if (selectedOperation instanceof WSOperation) {
                return (WSOperation)selectedOperation;
            }
        }
        return null;
    }

    private void performBasicAction() {
        try {
            this.resetMessages();
            if (this.m_instructionDef != null) {
                WSOperation wsOperation = this.getSelectedOperation();
                this.m_incomingParamPanel.reinitialize(this.m_instructionDef, wsOperation);
                this.m_outgoingParamPanel.reinitialize(this.m_instructionDef, wsOperation);
                this.m_authPropertyData.setDirty();
            }
            this.setMode(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performAdvancedAction() {
        try {
            this.resetMessages();
            WSOperation wsOperation = this.getSelectedOperation();
            if (wsOperation != null) {
                String template = wsOperation.getExpressionInMessageTemplate();
                this.setOutgoingMsgText(template);
            }
            this.setMode(1);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateOutgoingMsg() {
        try {
            if (this.m_instructionDef != null) {
                String inputMsg = this.m_outgoingMsgTextArea.getText();
                this.m_instructionDef.setInputMsgExpr(inputMsg);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setOutgoingMsgText(String text) {
        try {
            this.m_outgoingMsgTextArea.setText(text);
            if (this.m_instructionDef != null) {
                this.m_instructionDef.setInputMsgExpr(text);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performIncomingXMLDataFieldAction() {
        try {
            String xmlDataField = (String)this.m_incomingXMLDataFieldComboBox.getSelectedItem();
            if (VWStringUtils.compare(xmlDataField, VWResource.s_noneItemStr) == 0) {
                xmlDataField = null;
            }
            if (this.m_instructionDef != null) {
                this.m_instructionDef.setOutputMsgExpr(xmlDataField);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void setMode(int nMode) {
        switch (nMode) {
            case 0: {
                this.m_incomingParamPanel.setVisible(true);
                this.m_outgoingParamPanel.setVisible(true);
                this.m_outgoingMsgBorder.setVisible(false);
                this.m_incomingXMLDataFieldBorder.setVisible(false);
                this.m_basicRB.removeActionListener(this);
                this.m_basicRB.setSelected(true);
                this.m_basicRB.addActionListener(this);
                if (this.m_parentWSParamPanel == null) break;
                this.m_parentWSParamPanel.switchCSPanelBasicMode();
                break;
            }
            case 1: {
                this.m_incomingParamPanel.setVisible(false);
                this.m_outgoingParamPanel.setVisible(false);
                this.m_outgoingMsgBorder.setVisible(true);
                this.m_incomingXMLDataFieldBorder.setVisible(true);
                boolean bEnable = false;
                WSOperation wsOperation = this.getSelectedOperation();
                if (wsOperation != null && wsOperation.getOutMessage() != null) {
                    bEnable = wsOperation.getOutMessage().getMessage() != null;
                }
                this.m_incomingXMLDataFieldComboBox.setEnabled(bEnable);
                this.m_advancedRB.removeActionListener(this);
                this.m_advancedRB.setSelected(true);
                this.m_advancedRB.addActionListener(this);
                if (this.m_parentWSParamPanel == null) break;
                this.m_parentWSParamPanel.reinitializeCorrelationParamList();
                this.m_parentWSParamPanel.switchCSPanelAdvancedMode();
            }
        }
    }

    private void resetMessages() {
        try {
            if (this.m_instructionDef != null) {
                this.m_instructionDef.deleteAllParameters();
                this.setOutgoingMsgText(null);
                if (this.m_incomingXMLDataFieldComboBox != null && this.m_incomingXMLDataFieldComboBox.getModel().getSize() > 0) {
                    this.m_incomingXMLDataFieldComboBox.setSelectedIndex(0);
                }
                this.m_incomingParamPanel.reinitialize(null, null);
                this.m_outgoingParamPanel.reinitialize(null, null);
                this.m_instructionDef.setInputCorrelationSetName(null);
                this.m_instructionDef.setInputCorrelationSetProperties(null);
                this.m_instructionDef.setOutputCorrelationSetName(null);
                this.m_instructionDef.setOutputCorrelationSetProperties(null);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

